#ifndef DAT_FILTER_H_INCLUDED
#define DAT_FILTER_H_INCLUDED
//----------------------------------------------------------
//	DAT.H
//----------------------------------------------------------
extern const float DATGeometryCoef;

typedef struct tDATHeader
{
  DWORD		ID;
  DWORD		Version;
  long		NumVertices;
  DWORD		FileID;
  long		Zeros[6];
  DWORD		reserved1;
  DWORD		Unk1;//0x40;
  long		VertsOffset;
  DWORD		reserved2[3];
  long		Unk2;//0x10000;
  long		Unk3;//0;
  long		NumVertices2;//same as NumVertices;
  long		NumFaceIndexes;// divide to 3 to get num of faces;
  long		VertsOffset2;//same as VertsOffset;
  long		Unk4;//0x60
  DWORD		reserved3[2];
  
  tDATHeader()
  {
    memset(this, 0, sizeof(tDATHeader));
    ID          = 0x104;
    Version     = 1;
    FileID      = 0x44336518;
    Unk1        = 0x40;
    Unk2        = 0x10000;
    Unk3        = 0;
    Unk4        = 0x60;
  }
}tDATHeader;


typedef struct tDATVert
{
  float x,y,z,nx,ny,nz,u,v;
}tDATVert;

#endif
